function [varargout]=matricesdivP2P02D
% MATRICESDIVP2P02D local divergence matrices for the (P2,P1) 
% mixed 2D elements.
%   [DIVX,DIVY]=MATRICESDIVP2P02D computes the following local matrices: 
%
%   DIVX = (DIVX(I,J)) = - (Int(Tref) psi_J * d(phi_I)/dx dT),  
%   DIVY = (DIVY(I,J)) = - (Int(Tref) psi_J * d(phi_I)/dy dT).
%
% where psi_J is the J-th basis function of the P1 finite elements
% space and phi_I the I-th of the P2 finite elements space.

%      

varargout(1) = {[ 1/6 ;
                  -1/6 ;  
                  0 ;  
                  0;
                 -2/3; 
		         2/3 ]};
varargout(2) = {[ 1/6; 
                  0 ;  
                  -1/6;  
                  2/3 ; 
                 -2/3; 
		           0  ]};
                                         
return
